/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.cparser;

import com.ibm.hwmca.fw.util.cparser.ParserDataObj;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CparserString
extends ParserDataObj {
    private String codePage = null;
    private boolean nullTerminate = false;

    public CparserString() {
    }

    public CparserString(int dataLength, boolean nullTerm, Method inMethod, Object invokeObject, boolean skipIfNull) {
        super(dataLength, inMethod, invokeObject, skipIfNull);
        this.setNullTerminate(nullTerm);
    }

    public CparserString(int dataLength, boolean nullTerm, Method inMethod, Object invokeObject, boolean skipIfNull, String encoding) {
        super(dataLength, inMethod, invokeObject, skipIfNull);
        this.setNullTerminate(nullTerm);
        this.setEncoding(encoding);
    }

    public void setLength(int inputLength) {
        this.dataLength = inputLength;
    }

    public void setEncoding(String encoding) {
        this.codePage = encoding;
    }

    public void setNullTerminate(boolean value) {
        this.nullTerminate = value;
    }

    public void setMethod(Method inputMethod) {
        this.methodToCall = inputMethod;
    }

    int process(int offset, byte[] inputArray) throws UnsupportedEncodingException, IllegalAccessException, InvocationTargetException {
        String parseString = null;
        int nullIndex = 0;
        if (this.dataLength + offset > inputArray.length) {
            return inputArray.length;
        }
        boolean skipIt = false;
        if (this.isSkipIfNull() && inputArray[0] == 0) {
            skipIt = true;
            this.setSkipped(true);
        }
        if (!skipIt) {
            if (this.nullTerminate) {
                while (nullIndex < this.dataLength) {
                    if (inputArray[offset + nullIndex] == 0) break;
                    ++nullIndex;
                }
            }
            parseString = this.codePage != null ? new String(inputArray, offset, nullIndex, this.codePage) : new String(inputArray, offset, nullIndex);
            this.methodToCall.invoke(this.objectToInvoke, (Object[])new String[]{parseString});
        }
        return offset + this.dataLength;
    }
}

